-- Find the angle between that vector and the view direction vector for the player
function player_view_angle(p,player)
	-- Calculate the vector between the player and the object
	local povec = vector.subtract(p,player:getpos())
	
	-- Get the view direction vector for the player
	local lkdir = player:get_look_dir()
	
	-- Use dot product [ A.B = ||A|| * ||B|| * cos(angle) ]
	local a_dot_b = povec.x * lkdir.x + povec.z * lkdir.z -- A.B
	local ab = math.sqrt((povec.x)^2 + (povec.z)^2) * math.sqrt((lkdir.x)^2 + (lkdir.z)^2) --||A||*||B||
	local angle = math.floor(math.acos(a_dot_b/ab) * 100 + 0.5) / 100 -- in rad
	return angle
end

-- the angel take a step
function calc_next_step(p,player)
	local opvec = vector.subtract(player:getpos(),p)
	opvec.x = math.ceil(opvec.x)
	opvec.y = math.ceil(opvec.y)
	opvec.z = math.ceil(opvec.z)
	
	local newp = {x=p.x,y=p.y,z=p.z}
	if math.abs(opvec.x) > math.abs(opvec.z) then
		newp.x = newp.x + ( opvec.x/math.abs(opvec.x) )
	elseif math.abs(opvec.x) < math.abs(opvec.z) then
		newp.z = newp.z + ( opvec.z/math.abs(opvec.z) )
	else
		if opvec.x == 0 and opvec.z == 0 then
			newp.x = newp.x + 0
			newp.z = newp.z + 0
		else
			newp.x = newp.x + ( opvec.x/math.abs(opvec.x) )
			newp.z = newp.z + ( opvec.z/math.abs(opvec.z) )
		end
	end
	return newp
end

-- player will be send to the past
--(jk, just to random location at present)
-- after being touched by the angel
function find_rand_pos(player)
	local mult = 1
	if player:get_hp() > 1 then
		mult = math.ceil(player:get_hp()/2)
		player:set_hp(mult)
	end
	local rpos = {
		x=math.random(-200*mult,200*mult),
		y=0,
		z=math.random(-200*mult,200*mult)
	}
	--[[
	print(minetest.env:get_node(rpos).name)
	if minetest.env:get_node(rpos).name ~= "air" or minetest.env:get_node(rpos).name == "ignore" then
		local count_ignore = 0
		while minetest.env:get_node(rpos).name ~= "air" or minetest.env:get_node(rpos).name == "ignore" and count_ignore < 5 do
			rpos.y = rpos.y + 5
			print(minetest.env:get_node(rpos).name)
			if minetest.env:get_node(rpos).name == "ignore" then
				count_ignore = count_ignore + 1
				print(count_ignore)
			end
		end
	end
	--]]
	return rpos
end